/*

 */
package bretopidesktop;

import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;


/**
 *
 * @author 
 */
public class Sentence implements java.io.Serializable {
    
    public String originalSentence = "";
    public List<String> objects;
    public List<String> subjects;
    public List<String> verbs;
    public String linguisticAnalysisDetails = "";
    public List<String> topic;
    public String topicAnalysisDetails = "";
    public String posTags = "";
    public List<Word> bag_of_words;
    public String bag_of_words_str = "";
    public List<Word> sanitized_bag_of_words;
    public List<LocalContextEntity> localContextEntityList;
    public String goldStandardMatching = "";
    
    // we may need to group sentences in the future. 
    //public String groupLabel = "";
    
    public Sentence()
    {
        // Representation in natural language:
        originalSentence = "";
        goldStandardMatching = "";
        // Representation as sets of lexical items:
        objects = new ArrayList<String>();
        subjects = new ArrayList<String>();
        verbs = new ArrayList<String>();

        // Representation in vectors based on statistical word occurrence: 
        sanitized_bag_of_words= new ArrayList<Word>();
        
        // Representation in a set of related local context entities:
        localContextEntityList = new ArrayList<LocalContextEntity>();
        
        // Analysis elements:
        linguisticAnalysisDetails = "";
        topic = new ArrayList<String>();
        topicAnalysisDetails = "";
        posTags = "";
        bag_of_words = new ArrayList<Word>();
        bag_of_words_str = "";
    }
        
    public String dump()
    {
        String s = "";
         
        s = s + "Original Sentence: " + this.originalSentence + System.lineSeparator();     
        s = s + "Objects: " + this.objects.toString() + System.lineSeparator(); 
        s = s + "Subjects: " + this.subjects.toString() + System.lineSeparator(); 
        s = s + "Verbs: " + this.verbs.toString() + System.lineSeparator();
        s = s + "linguistic analysis details: " +  this.linguisticAnalysisDetails + System.lineSeparator();   
        s = s + "POS tag list: " +  this.posTags + System.lineSeparator();   
                
        s = s + "Bag-of-Words: " + Common.BOWtoString(this.bag_of_words) + System.lineSeparator();  
        s = s + "Sanitized Bag-of-Words: " + Common.BOWtoString(this.sanitized_bag_of_words) + System.lineSeparator();  
                
        s = s + "Local context entities: " + Common.localContextEntitiesToString(this.localContextEntityList) + System.lineSeparator();
        return s;
    }
    public boolean writeToFile(List<Sentence> s, String path)
    {
        boolean ret = false;
        
        try {
            FileWriter fw = new FileWriter(path);
            
            for (int x=0; x<s.size(); x++)
            {
                
                fw.write(s.get(x).dump());
                fw.write("-------------------------------------" + System.lineSeparator() + System.lineSeparator());   
                
            }
            fw.close();
            
            ret = true;
        }
        catch (Exception e)
        {
            ret = false;
        }
        return ret;
    }
}
