/*

 */
package bretopidesktop;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import scala.collection.parallel.ParIterableLike;

/**
 * This class contains the commonly used functions.
 * @author 
 */
public class Common {
    
    // Prints the text with a timestamp on the console 
    public static void log(String text)
    {
        Date dateobj = new Date();
        DateFormat df = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        System.out.println(df.format(dateobj) + " > " + text);
    }
     
    // Using a Regex, this method checks if the containedObject (String) is contained within the bigString or not. 
     public static boolean containsWithoutCharacterBounds(String bigString, String containedObject)
    {
        bigString = bigString.replace("\n", " ");
        boolean ret = false;
        try
        {
         // Case insensitive, must not have any alphabetic character neighbors.
             String regex = "(?i)(^|(.*\\W))\\Q" + containedObject + "\\E($|(\\W.*))";
            if(containedObject.length()<3)
            {
                regex = "(^|(.*\\W))\\Q" + containedObject + "\\E($|(\\W.*))";
            }
           
         ret =  bigString.matches(regex);
        }
        catch(Exception e)
        {
            System.out.println(e);
        }
          return ret;
    }
     
     // Using a Regex, this method checks if the containedObject (String) is contained within the bigString or not. 
     public static boolean containsWithoutCharacterBoundsCaseSensitive(String bigString, String containedObject)
    {
        bigString = bigString.replace("\n", " ");
        boolean ret = false;
        try
        {
         // Case insensitive, must not have any alphabetic character neighbors.
         String regex = "(^|(.*\\W))\\Q" + containedObject + "\\E($|(\\W.*))";
         ret =  bigString.matches(regex);
        }
        catch(Exception e)
        {
            System.out.println(e);
        }
          return ret;
    }
     
     // This method checks if the bag_of_words includes a given String or not. 
     public static boolean BOWcontainsString(List<Word> bag_of_words, String wrd)
     {
         boolean ret = false;
         for (int x=0; x<bag_of_words.size(); x++)
         { 
             if(bag_of_words.get(x).word.equalsIgnoreCase(wrd))
             {
                 ret = true;
             }
         }
         return ret;
     }
     
     // Eliminates the duplicates in a List of Words and returns a unique Word List.
     public static List<Word> getUniqueWordList(List<Word> inputWordList)
    {
        List<Word> outputWordList = new ArrayList<Word>();
        for(int i=0; i<inputWordList.size(); i++)
        {
            boolean isInUniqueList = false;
            for(int j=0; j<outputWordList.size(); j++)
            {
                if(inputWordList.get(i).word.equalsIgnoreCase(outputWordList.get(j).word))
                {
                    isInUniqueList = true;
                }
            }
            if(!isInUniqueList)
            {
                outputWordList.add(inputWordList.get(i));
            }
        }
        return outputWordList;
    }
     
     // Converts a bag-of-words to a String. 
    public static String BOWtoString(List<Word> bag_of_words)
    {
        String oString = "";
         for (int x=0; x<bag_of_words.size(); x++)
         {
             //oString = oString + ", " + bag_of_words.get(x).word + "(tfidf=" + String.format("%.2f", bag_of_words.get(x).tfIDF) + "|tf=" + String.format("%.2f", bag_of_words.get(x).tf) + " |idf=" + String.format("%.2f", bag_of_words.get(x).idf) + ")";
            if(x<bag_of_words.size()-1)
            {
                oString = oString + bag_of_words.get(x).dump() + " ,";
            }
            else
            {
                oString = oString + bag_of_words.get(x).dump();
            }
         }
        return oString;
    }
    
    // Converts a bag-of-words to a String. 
    public static String BOWtoBootstrapTags(List<Word> bag_of_words)
    {
        String oString = "";
         for (int x=0; x<bag_of_words.size(); x++)
         {
           
                oString = oString + "<span class=\"label label-primary\">" + bag_of_words.get(x).word + " (" +  String.format("%.2f", bag_of_words.get(x).tfIDF) + ")</span> | ";
            

         }
        return oString;
    }
     
    // Converts a LocalContextEntity List to a String 
    public static String localContextEntitiesToString(List<LocalContextEntity> localContextEntityList)
    {
        String vString = "[";
         for (int x=0; x<localContextEntityList.size(); x++)
         {

             if(x==0)
             {
                vString = vString  + localContextEntityList.get(x).name + " (" + localContextEntityList.get(x).type + ") ";
             }
             else
             {
                vString = vString + ", " + localContextEntityList.get(x).name + " (" + localContextEntityList.get(x).type + ") ";
             }
         }
            vString = vString + "]";
        return vString;
    }
    
    // Returns the union of two input String lists
    public static List<String> unionOfTwoStringSets(List<String> set1, List<String> set2)
    {
       List<String> unionSet = new ArrayList<String>();
       unionSet.addAll(set2);
       unionSet.addAll(set1); 
       unionSet = getUniqueStringSet(unionSet);
       return unionSet;
    }
    
    // Returns the intersection of two String lists
    public static List<String> intersectionOfTwoStringSets(List<String> set1, List<String> set2)
    {
        List<String> intersectionSet = new ArrayList<String>();
        for(int i=0; i<set1.size(); i++)
        {
            for(int j=0; j<set2.size(); j++)
            {
                if(set1.get(i).equalsIgnoreCase(set2.get(j)))
                {
                    intersectionSet.add(set1.get(i));
                }
            }
        }

       intersectionSet = getUniqueStringSet(intersectionSet);
       return intersectionSet;
    }
    
    // Returns the intersection of two LocalContextEntity Lists
    public static List<LocalContextEntity> intersectionOfTwoLocalContextSets(List<LocalContextEntity> set1, List<LocalContextEntity> set2)
    {
        List<LocalContextEntity> intersectionSet = new ArrayList<LocalContextEntity>();
        for(int i=0; i<set1.size(); i++)
        {
            for(int j=0; j<set2.size(); j++)
            {
                if(set1.get(i).name.equalsIgnoreCase(set2.get(j).name) && set1.get(i).type.equalsIgnoreCase(set2.get(j).type))
                {
                    intersectionSet.add(set1.get(i));
                }
            }
        }
        
       intersectionSet = getUniqueLocalContextSet(intersectionSet);
       return intersectionSet;
    }
 
        public static String stringListToString(List<String> sList)
        {
            String listString = "";

            for (int i=0; i<sList.size(); i++)
            {
                if(i < sList.size()-1)
                {
                    listString += sList.get(i) + ", ";
                }
                else
                {
                    listString +=  sList.get(i);
                }
            }
            
            return listString;
        }
    
    // Returns the difference of two LocalContextEntity lists. (set1 - set2)
    public static List<LocalContextEntity> differenceOfTwoLocalContextSets(List<LocalContextEntity> set1, List<LocalContextEntity> set2)
    {
        List<LocalContextEntity> differenceSet = new ArrayList<LocalContextEntity>();
        for(int i=0; i<set1.size(); i++)
        {
            for(int j=0; j<set2.size(); j++)
            {
                if(set1.get(i).name.equalsIgnoreCase(set2.get(j).name) && set1.get(i).type.equalsIgnoreCase(set2.get(j).type))
                {
                  
                }
                else
                {
                  differenceSet.add(set1.get(i));
                }
            }
        }

       differenceSet = getUniqueLocalContextSet(differenceSet);
       return differenceSet;
    }
    
    // Eliminates the duplicates in a List of Strings and returns a unique String List.
    public static List<String> getUniqueStringSet(List<String> inputStringSet)
    {
        List<String> outputStringSet = new ArrayList<String>();
        for(int i=0; i<inputStringSet.size(); i++)
        {
            boolean isInUniqueList = false;
            for(int j=0; j<outputStringSet.size(); j++)
            {
                if(inputStringSet.get(i).equalsIgnoreCase(outputStringSet.get(j)))
                {
                    isInUniqueList = true;
                }
            }
            if(!isInUniqueList)
            {
                outputStringSet.add(inputStringSet.get(i));
            }
        }
        return outputStringSet;
    }
    
    // Eliminates the duplicates in a List of LocalContextEntities and returns a unique LocalContextEntity List.
    public static List<LocalContextEntity> getUniqueLocalContextSet(List<LocalContextEntity> inputSet)
    {
        List<LocalContextEntity> outputSet = new ArrayList<LocalContextEntity>();
        for(int i=0; i<inputSet.size(); i++)
        {
            boolean isInUniqueList = false;
            for(int j=0; j<outputSet.size(); j++)
            {
                if(inputSet.get(i).name.equalsIgnoreCase(outputSet.get(j).name) && inputSet.get(i).type.equalsIgnoreCase(outputSet.get(j).type))
                {
                    isInUniqueList = true;
                }
            }
            if(!isInUniqueList)
            {
                outputSet.add(inputSet.get(i));
            }
        }
        return outputSet;
    }
     
    // Serialize an object and write it to the designated file
    public static boolean serializeObj( Object o, String fileName)
    {
        boolean ret = false;
        try {
         FileOutputStream fileOut =
         new FileOutputStream(fileName);
         ObjectOutputStream out = new ObjectOutputStream(fileOut);
         out.writeObject(o);
         out.close();
         fileOut.close();
         Common.log("Serialization complete: " + fileName);
         ret = true;
      }catch(IOException i) {
          ret = false;
         i.printStackTrace();
      }
        return ret;
    }
    
    // Deserialize (Create) a ProcessModel list object from the designated file
    public static List<ProcessModel> deserializePmList(String filename)
    {
        List<ProcessModel> pmListNew =  new ArrayList<ProcessModel>(); 
    try {
         FileInputStream fileIn = new FileInputStream(filename);
         ObjectInputStream in = new ObjectInputStream(fileIn);
         pmListNew = (List<ProcessModel>) in.readObject();
         in.close();
         fileIn.close();
      }catch(IOException i) {
         i.printStackTrace();
         return null;
      }catch(ClassNotFoundException c) {
         Common.log("Deserialization failed. class not found");
         c.printStackTrace();
         return null;
      }
    return pmListNew;
    }
     
     // Deserialize (Create) a Sentence list object from the designated file
    public static List<bretopidesktop.Sentence> deserializeSentenceList(String filename)
    {
        List<bretopidesktop.Sentence> sentenceListNew =  new ArrayList<bretopidesktop.Sentence>(); 
    try {
         FileInputStream fileIn = new FileInputStream(filename);
         ObjectInputStream in = new ObjectInputStream(fileIn);
         sentenceListNew = (List<bretopidesktop.Sentence>) in.readObject();
         in.close();
         fileIn.close();
      }catch(IOException i) {
         i.printStackTrace();
         return null;
      }catch(ClassNotFoundException c) {
         Common.log("Deserialization failed. class not found");
         c.printStackTrace();
         return null;
      }
    return sentenceListNew;
    }
    
    
    public static void processIDFofProcessActivityDescriptions(List<ProcessModel> pmList)
    {
        for (int x=0; x<pmList.size(); x++) // for each process model
        {
            for (int i=0; i<pmList.get(x).activityList.size(); i++) // for each activity
            {
                for (int j=0; j<pmList.get(x).activityList.get(i).descriptionSentence.sanitized_bag_of_words.size(); j++) // for each word
                {
                    pmList.get(x).activityList.get(i).descriptionSentence.sanitized_bag_of_words.get(j).idf = 
                            calculateIDFofProcessActivityDescriptions(pmList.get(x).activityList.get(i).descriptionSentence.sanitized_bag_of_words.get(j), pmList);
                    
                    pmList.get(x).activityList.get(i).descriptionSentence.sanitized_bag_of_words.get(j).tfIDF = pmList.get(x).activityList.get(i).descriptionSentence.sanitized_bag_of_words.get(j).tf * pmList.get(x).activityList.get(i).descriptionSentence.sanitized_bag_of_words.get(j).idf;
                }
                
            }
        }
    }
     public static void processIDFofProcessActivityLabels(List<ProcessModel> pmList)
    {
        for (int x=0; x<pmList.size(); x++) // for each process model
        {
            for (int i=0; i<pmList.get(x).activityList.size(); i++) // for each activity
            {
                for (int j=0; j<pmList.get(x).activityList.get(i).labelSentence.sanitized_bag_of_words.size(); j++) // for each word
                {
                    pmList.get(x).activityList.get(i).labelSentence.sanitized_bag_of_words.get(j).idf = 
                            calculateIDFofProcessActivityLabels(pmList.get(x).activityList.get(i).labelSentence.sanitized_bag_of_words.get(j), pmList);
                    
                    pmList.get(x).activityList.get(i).labelSentence.sanitized_bag_of_words.get(j).tfIDF = pmList.get(x).activityList.get(i).labelSentence.sanitized_bag_of_words.get(j).tf * pmList.get(x).activityList.get(i).labelSentence.sanitized_bag_of_words.get(j).idf;
                }
                
            }
        }
    }
    
    
    
     public static double calculateIDFofProcessActivityDescriptions(Word wrd, List<ProcessModel> pmList)
    {
        
        int activityCount = 0;
        int hitCount = 0;
        for (int x=0; x<pmList.size(); x++) // for each process model
        {
            activityCount = activityCount + pmList.get(x).activityList.size();
            for (int i=0; i<pmList.get(x).activityList.size(); i++) // for each activity
            {
                if(Common.BOWcontainsString(pmList.get(x).activityList.get(i).descriptionSentence.sanitized_bag_of_words, wrd.word))
                {
                    hitCount++;
                }
            }
        }
        double idf = 0;
        if(hitCount > 0)
        {
            idf = 1 + Math.log(activityCount / hitCount);
        }    
        return idf;
    }
    
     public static double calculateIDFofProcessActivityLabels(Word wrd, List<ProcessModel> pmList)
    {
        
        int activityCount = 0;
        int hitCount = 0;
        for (int x=0; x<pmList.size(); x++) // for each process model
        {
            activityCount = activityCount + pmList.get(x).activityList.size();
            for (int i=0; i<pmList.get(x).activityList.size(); i++) // for each activity
            {
                if(Common.BOWcontainsString(pmList.get(x).activityList.get(i).labelSentence.sanitized_bag_of_words, wrd.word))
                {
                    hitCount++;
                }

            }
        }
        double idf = 0;
        if(hitCount > 0)
        {
            idf = 1 + Math.log(activityCount / hitCount);
        }    
        return idf;
    }
     
    public static void calculateTF(bretopidesktop.Sentence s)
    {

        for(int nds=0; nds<s.sanitized_bag_of_words.size(); nds++)
        {
            double count = 0;  //to count the overall occurrence of the term termToCheck
            for (Word w : s.sanitized_bag_of_words) 
            {  
                if (w.word.equalsIgnoreCase(s.sanitized_bag_of_words.get(nds).word )) 
                {
                    count++;
                }
            }
            s.sanitized_bag_of_words.get(nds).tf = count / s.sanitized_bag_of_words.size();
        }
    }
     
    private static double getSumOfTfIDF(List<Word> wList)
    {
        double sum = 0;
        for(int i=0; i<wList.size(); i++)
        {
            sum = sum + wList.get(i).tfIDF;
            
        }
        return sum;
    }
    
    public static String emphasizeTopWordsInAStringForHTML(int topPercentage, Sentence s)
    {
        String retStr = s.originalSentence;
        int count = 0; 
        List<Word> bagOfWords = getUniqueWordList(s.sanitized_bag_of_words);
        count =  (int)Math.ceil( (double)(bagOfWords.size() * topPercentage / 100));
        
        List<Word> topBagOfWords = new ArrayList<Word>();
        Collections.sort(bagOfWords);
        
        for(int i=0; i<=count; i++)
        {
            topBagOfWords.add(bagOfWords.get(i));
        }
        
        List<String> objSubjVerbs = new ArrayList<String>();
        objSubjVerbs = unionOfTwoStringSets(s.objects, s.subjects);
        objSubjVerbs = unionOfTwoStringSets(objSubjVerbs, s.verbs);
        objSubjVerbs = getUniqueStringSet(objSubjVerbs);
        
        List<String> phrasesToEmphasize = new ArrayList<String>();
        for(int i=0; i<topBagOfWords.size(); i++)
        {
            for(int j=0; j<objSubjVerbs.size(); j++)
            {
                if(containsWithoutCharacterBounds(objSubjVerbs.get(j), topBagOfWords.get(i).word))
                {
                    phrasesToEmphasize.add(objSubjVerbs.get(j));
                }
            }
        }
        
        retStr = retStr.replace("<br>", " ");
        
        for(int i=0; i<phrasesToEmphasize.size(); i++)
        {
            retStr = retStr.replace(phrasesToEmphasize.get(i), " <mark>" + phrasesToEmphasize.get(i) + "</mark> ");
        }
        
        return retStr;
    }
    
     public static List<Word> getTheMostImportantWords(int topPercentage, Sentence s)
    {
        String retStr = s.originalSentence;
        int count = 0; 
        List<Word> bagOfWords = getUniqueWordList(s.sanitized_bag_of_words);
        count =  (int)Math.ceil( (double)(bagOfWords.size() * topPercentage / 100));
        
        List<Word> topBagOfWords = new ArrayList<Word>();
        Collections.sort(bagOfWords);
        
        for(int i=0; i<=count; i++)
        {
            topBagOfWords.add(bagOfWords.get(i));
        }
        
        return topBagOfWords; 
        
    }
    
}
