
# Objective Performance Evaluation of Teams with Process Mining
#This Notebook contains the analyses done for the research project. 

# STEP 3: DEA Implementation

# Loading libraries -------------------------------------------------------

library(lubridate)  #Data manipulation
library(plyr)       #Data manipulation
library(dplyr)      #Data manipulation
library(rDEA)       #Data Envelopment Analysis
library(knitr)      #Data manipulation
library(tm)         #Data manipulation
library(Matrix)     #Data manipulation
library(data.table) #Data manipulation
library(igraph)     #Social Network Analysis
library(stringr)    #String manipulation
library(extrafont)  #Additional fonts

# Initialization ----------------------------------------------------------

currDate = format(Sys.Date(), format = "%Y%m%d")
# Import and pre-processing of metric file
#Import the csv metrics file generated by R-script at the end of Stage 2 (metrics.csv)

#Choose the file
path = if (interactive() && .Platform$OS.type == "windows")
  choose.files(default = "", caption = "Select file",
               multi = FALSE, filters = Filters[c("zip", "All"),])

# Import dataset
df_final <-
  read.csv(path,
           header = TRUE,
           sep = ",",
           dec = ".")
# Data Envelopment Analysis -----------------------------------------------

# Setting input and output variables
dea.inp.var <- select(df_final,
                      "ProcessingTime",
                      "Throughput")
#"Loan")
dea.out.var <- select(df_final,
                      "Activities",
                      "Loan")

# Creating DEA model
dea.model <-
  rDEA::dea(
    XREF = dea.inp.var,
    YREF = dea.out.var,
    X = dea.inp.var[, ],
    Y = dea.out.var[, ],
    model = "input", #output, costmin
    RTS = "non-increasing" #constant, variable
  )

# Creating results table
dea <-
  cbind(round(dea.model$thetaOpt, 4), round(dea.model$lambda, 4))
rownames(dea) <- df_final[[1]]
colnames(dea) <- c("Efficiency", rownames(dea))
kable(dea[,])

# Adding resources to DEA table
dea.outcome <- df_final$Team
dea.outcome <- cbind(dea.outcome, data.frame(dea))
dea.outcome <- dea.outcome[order(-dea.outcome$Efficiency), ]
names(dea.outcome)[names(dea.outcome) == "dea.outcome"] <-
  "Team"

# Write DEA output
#Choose the path where you will save the DEA Output
path=if (interactive() && .Platform$OS.type == "windows")
  choose.dir(getwd(), "Choose a suitable folder")

filenameDEA = paste(path, "DEA_Output.csv")
write.csv(dea.outcome, filenameDEA)
#Use the output csv file as input to Step 4 in Jupyter Notebook
